function criaTabelaTpVenda(data) {
    function retornaBotaoOpcoes(data) {
        var retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes tpVendaDatatableButtonControl" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button type="button" class="dropdown-item tpVendaDatatableButtonControl" title="Excluir" id="btnExcluir">Excluir</button>     ' +
            '</div>';
        return retorno;
    }

    if ($.fn.DataTable.isDataTable('#tabelaTpVenda')) {
        $('#tabelaTpVenda').DataTable().destroy();
        $('#tabelaTpVenda').empty();
    }

    const columns = [
        {
            data: 'TIPO_VENDA',
            title: 'Tipo de Venda'
        },
        {
            data: 'EMPRESA',
            title: 'Empresa'
        },
        {
            data: 'COD_REGRA',
            title: 'Regra'
        },
        {
            data: 'DESCRICAO',
            title: 'Descrição Regra'
        },
        {
            data: 'TRIBUTACAO',
            title: 'Tributação'
        },
        {
            data: 'CODSPED',
            title: 'Cód. Sped'
        }
    ];

    $("#tabelaTpVenda").DataTable({
        sort: false,
        paging: false,
        destroy: true,
        lengthChange: false,
        filter: false,
        info: false,
        columnDefs: [
            {
                targets: [0],
                render: function (data) {
                    return retornaBotaoOpcoes(data);
                }
            }
        ],
        autoWidth: true,
        data,
        columns
    }).draw(false);
}

$('#btnAdicionarTipoRegra').on('click', async function () {
    const tipoVenda = $('#txtTipoVenda').val();
    const empresaTipo = pegaChave('#txtEmpresaRegra')
    const regra = pegaChave('#txtRegra');
    const regraDesc = pegaDescricao('#txtRegra');
    const tributacao = pegaValor('#selectTrib')
    const codsped = pegaChave('#txtSped')

    addTipoRegra(tipoVenda, empresaTipo, regra, regraDesc, tributacao, codsped);

    toastr.success(
        `Registro adicionado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 5000,
        fadeOut: 3000
    }
    ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
    });

    $('#txtTipoVenda').val('');
    $('#txtEmpresaRegra').val('');
    $('#txtRegra').val('');
});

async function addTipoRegra(tipoVenda, empresaTipo, regra, regraDesc, tributacao, codsped) {
    try {
        $.LoadingOverlay('show');

        if (!tipoVenda || !empresaTipo || !tributacao || !codsped) {
            msgAlerta('Favor preencher todos os campos obrigatórios!');
            return;
        }

        const obj = {
            TIPO_VENDA: tipoVenda,
            EMPRESA: empresaTipo,
            COD_REGRA: regra,
            DESCRICAO: regraDesc,
            TRIBUTACAO: tributacao,
            CODSPED: codsped
        }

        $('#tabelaTpVenda').DataTable().row.add(obj).draw(false);

    } finally {
        $.LoadingOverlay('hide');
    }
};

async function preenhceTpVendaPadrao(obj) {
    const descRegra = obj.regra != '' ? await buscaValor('REGRA', 'DESCRICAO', 'CODIGO', obj.regra) : ''
    obj.descRegra = descRegra?.DESCRICAO ?? ''

    const pesquisa = {
        camposSelect: [`REPLACE(EMPRESA.EMP_PAT,'_','') EMPRESA`],
        tabela: `EMPRESA`,
        orderBy: ['EMPRESA.EMP_PAT'],
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    if (jsonStr && jsonStr.length > 0) {
        for (let i = 0; i < jsonStr.length; i++) {
            addTipoRegra(obj.tpVenda, jsonStr[i].EMPRESA, obj.regra, obj.descRegra, obj.tributacao, obj.sped)
        }
    }
}